local dragonvortex={}
function dragonvortex.load()
local canvasWidth,canvasHeight=1920,1080
centerX,centerY=canvasWidth/2,canvasHeight/2
numPoints=100
points={}
vortexTime=0
vorteximage1=love.graphics.newImage("dragonicon1.png")
vorteximage2=love.graphics.newImage("dragonicon2.png")
vorteximage3=love.graphics.newImage("dragonicon3.png")
vorteximage4=love.graphics.newImage("dragonicon4.png")
vorteximage5=love.graphics.newImage("dragonicon5.png")
vorteximage6=love.graphics.newImage("dragonicon6.png")
vorteximage7=love.graphics.newImage("dragonicon7.png")
vorteximage8=love.graphics.newImage("dragonicon8.png")
vorteximage9=love.graphics.newImage("dragonicon9.png")
vorteximages={vorteximage1,vorteximage2,vorteximage3,vorteximage4,vorteximage5,vorteximage6,vorteximage7,vorteximage8,vorteximage9}
scaleFactor=0.5
hueShiftShader=love.graphics.newShader([[
extern float hueShift; // 0..1
vec3 rgb2hsv(vec3 c){
vec4 K = vec4(0.0, -1.0/3.0, 2.0/3.0, -1.0);
vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));
float d = q.x - min(q.w, q.y);
float e = 1.0e-10;
return vec3(abs(q.z + (q.w - q.y) / (6.0*d + e)), d / (q.x + e), q.x);
}
vec3 hsv2rgb(vec3 c){
vec3 p = abs(fract(c.xxx + vec3(0.0, 1.0/3.0, 2.0/3.0)) * 6.0 - 3.0);
vec3 rgb = c.z * mix(vec3(1.0), clamp(p - 1.0, 0.0, 1.0), c.y);
return rgb;
}
vec4 effect(vec4 color, Image tex, vec2 texture_coords, vec2 screen_coords){
vec4 px = Texel(tex, texture_coords);
vec3 hsv = rgb2hsv(px.rgb);
hsv.x = fract(hsv.x + hueShift);
vec3 rgb = hsv2rgb(hsv);
return vec4(rgb, px.a) * color;
} ]])
for i=1,numPoints do
local angle=(i/numPoints)*math.pi*2*5
local radius=(i/numPoints)*500
local selectedImage=vorteximages[math.random(1,#vorteximages)]
local hueShift=math.random()
local flipX=(math.random()<0.5)
table.insert(points,{x=centerX+radius*math.cos(angle),y=centerY+radius*math.sin(angle),angle=angle,radius=radius,image=selectedImage,hueShift=hueShift,flipX=flipX})
end end
function dragonvortex.update(dt)
vortexTime=vortexTime+dt
for i,point in ipairs(points) do
point.angle=point.angle+dt*1.5
point.radius=(i/numPoints)*(950+850*math.sin(vortexTime))
point.x=centerX+point.radius*math.cos(point.angle)
point.y=centerY+point.radius*math.sin(point.angle)
end end
function dragonvortex.draw()
love.graphics.setColor(1,1,1)
love.graphics.setShader(hueShiftShader)
for i,point in ipairs(points) do
local img=point.image
local w,h=img:getWidth(),img:getHeight()
hueShiftShader:send("hueShift",point.hueShift)
local sx=scaleFactor*(point.flipX and -1 or 1)
local sy=scaleFactor
love.graphics.draw(img,point.x,point.y,0,sx,sy,w/2,h/2)
end
love.graphics.setShader()
end
return dragonvortex
